-------------------------------------------------
-- synchronizor_tb.vhd
--
-- Author:   Steve Dillen
-- Date:     Oct 31, 2000 
-- Course:   EE552
-- Desc:
--
-- This testbench will test the synchronizor input and output
-- (Very simple testbench...)
--

library ieee;
use ieee.std_logic_1164.all;

-- Test Bench
--
entity synchronizor_tb is
end synchronizor_tb;

architecture mixed of synchronizor_tb is

	component synchronizor is

    port( clock        : in  std_logic;
          reset        : in  std_logic;
          input        : in  std_logic;
          output       : out std_logic
        );

  end component synchronizor;

  -- Clock period / 2
  --
  constant T_pw       : time     := 20 ns;

  -- Generated control signals
  --
  signal clock        : std_logic;
  signal reset        : std_logic;

  -- Generated data signals
  -- Don't need to delay the input since it will be asynchronous anyways
  --
  signal input        : std_logic;
  signal output       : std_logic;

begin

  -- Configure a synchronizor
  --
	reflector : synchronizor port map (
                                      clock  => clock,
                                      reset  => reset,
                                      input  => input,
                                      output => output
                                    );

	-- clock generator
  --
	clock_gen : process
	begin

		clock <= '0';
    wait for T_pw;
    clock <= '1';
    wait for T_pw;

	end process clock_gen;

	-- process to control the reset signal
  --
	reset_control : process
	begin
		
		-- Reset the circuit
    --
		reset <= '1';
		wait for 80 ns;

    -- Take out of reset
    --
		reset <= '0';
		wait for 1 us;

    -- Reset the circuit to show synchronized reset
    --
		reset <= '1';
		wait for 250 ns;

    -- Keep out of reset for the rest of the simulation
    --
    reset <= '0';
		wait;

	end process reset_control;

	-- process to control data inputs
  --
	input_control : process
	begin

    -- Start with 0's on the lines
    --
    input <= '0';

    -- Wait for a while clock cycles
    --
    wait for 10 * 2 * T_pw;

    -- Turn on input
    --
    input <= '1';
    wait for 3 * T_pw;
    input <= '0';

    -- Wait 4 clock pulses, don't bother trying to match clock edges,
    -- since this is simulating an asynchronous input
    --
    wait for 4 * 2 * T_pw;

    -- Show a couple of glitches on the line
    --
    input <= '1';
    wait for 3 ns;
    input <= '0';
    wait for 10 ns;
    input <= '1';
    wait for 5 ns;
    input <= '0';
    wait for 1 ns;
    input <= '1';
    wait for 7 ns;
    input <= '0';
    wait for 3 ns;
    input <= '1';
    wait for 10 ns;
    input <= '0';
    input <= '1';
    wait for 3 ns;
    input <= '0';
    wait for 10 ns;
    input <= '1';
    wait for 5 ns;
    input <= '0';
    wait for 1 ns;
    input <= '1';
    wait for 7 ns;
    input <= '0';
    wait for 3 ns;
    input <= '1';
    wait for 10 ns;
    input <= '0';

    wait for 2 * 2 * T_pw;

    input <= '1';

    wait;

	end process input_control;	

end mixed;
