-------------------------------------------------
-- pwm_generator_tb.vhd
--
-- Author:   Steve Dillen
-- Date:     November 15, 2000 
-- Course:   EE552
-- Desc:
--
-- This testbench will test the pwm_generator which will accept
-- a duty cycle and generate a PWM from that cycle
--

-- Include ieee std_logic types
--
library ieee;
use ieee.std_logic_1164.all;

-- Test Bench
--
entity pwm_generator_tb is
end pwm_generator_tb;

architecture mixed of pwm_generator_tb is

  component pwm_generator is

    port    ( clock      : in  std_logic;
              reset      : in  std_logic;
              duty_cycle : in  std_logic_vector( 1 downto 0 );
              pwm_signal : out std_logic
            );

  end component pwm_generator;

  -- Clock period / 2
  --
  constant T_pw       : time     := 20 ns;
  constant delay_time : time     := 10 ns;
  constant busWidth   : positive := 2;

  -- Generated control signals
  --
  signal clock        : std_logic;
  signal reset        : std_logic;

  -- Generated input signals
  --
  signal duty_cycle : std_logic_vector( 1 downto 0 );
  
  -- Delay the inputs so they aren't changing on the rising edge of the clock
  -- 
  signal duty_cycle_delayed : std_logic_vector( 1 downto 0 );

  -- Outputs don't need to be delayed.
  --
  signal pwm_signal : std_logic;

begin

  -- Delay the inputs
  --
  duty_cycle_delayed <= duty_cycle after delay_time;

  -- Configure a pwm
  --
	reflector : pwm_generator port map (
                                       clock      => clock,
                                       reset      => reset,
                                       duty_cycle => duty_cycle_delayed,
                                       pwm_signal => pwm_signal
                                     );

	-- clock generator
  --
	clock_gen : process
	begin

		clock <= '0';
    wait for T_pw;
    clock <= '1';
    wait for T_pw;

	end process clock_gen;

	-- process to control the reset signal
  --
	reset_control : process
	begin
		
		-- Reset the circuit
    --
		reset <= '1';
		wait for 4 * T_pw;

    -- Take out of reset
    --
		reset <= '0';
		wait for 4 * 76 * T_pw;

    -- Reset the circuit to show synchronized reset
    --
		reset <= '1';
		wait for 10 * T_pw;

    -- Keep out of reset for the rest of the simulation
    --
    reset <= '0';
		wait;

	end process reset_control;

	-- process to control data inputs
  --
	input_control : process
	begin

    -- Start with 0's on the lines
    --
    duty_cycle <= ( others => '0' );

    -- Wait for a few clock cycles
    --
    wait for 40 * 2 * T_pw;

    -- Change to a duty cycle of 1
    --
    duty_cycle(0) <= '1';
    wait for 40 * 2 * T_pw;

    -- Change to a duty cycle of 3
    --
    duty_cycle(1) <= '1';
    wait for 40 * 2 * T_pw;

    -- Change to a duty cycle of 2
    --
    duty_cycle(0) <= '0';
    wait for 40 * 2 * T_pw;

    -- Leave on to see synchronous reset
    --
    wait;

	end process input_control;	

end mixed;
