-------------------------------------------------
-- photo_reflector_tb.vhd
--
-- Author:   Steve Dillen
-- Date:     Oct 30, 2000 
-- Course:   EE552
-- Desc:
--
-- This testbench will test the photo-reflector input and output
-- (Very simple testbench...)
--

library ieee;
use ieee.std_logic_1164.all;

-- Test Bench
--
entity photo_reflector_tb is
end photo_reflector_tb;

architecture mixed of photo_reflector_tb is

	component photo_reflector is

    port( clock        : in  std_logic;
          reset        : in  std_logic;
          tx           : in  std_logic;
          rx           : out std_logic;
          input        : in  std_logic;
          output       : out std_logic
        );

  end component photo_reflector;

  -- Clock period / 2
  --
  constant T_pw       : time     := 20 ns;

  -- Generated control signals
  --
  signal clock        : std_logic;
  signal reset        : std_logic;

  -- Generated data signals
  signal tx           : std_logic;
  signal rx           : std_logic;
  signal input        : std_logic;
  signal output       : std_logic;

begin

  -- Configure a photo_reflector
  --
	reflector : photo_reflector port map (
                                         clock  => clock,
                                         reset  => reset,
                                         tx     => tx,
                                         rx     => rx,
                                         input  => input,
                                         output => output
                                       );

	-- clock generator
  --
	clock_gen : process
	begin

		clock <= '0' after T_pw, '1' after 2 * T_pw;
		wait for 2*T_pw;

	end process clock_gen;

	-- process to control the reset signal
  --
	reset_control : process
	begin
		
		-- Reset the circuit
    --
		reset <= '1';
		wait for 80 ns;

    -- Take out of reset
    --
		reset <= '0';
		wait for 1 us;

    -- Reset the circuit to show synchronized reset
    --
		reset <= '1';
		wait for 250 ns;

    -- Keep out of reset for the rest of the simulation
    --
    reset <= '0';
		wait;

	end process reset_control;

	-- process to control data lines
  --
	input_control : process
	begin

    -- Start with 0's on the lines
    --
    tx    <= '0';
    input <= '0';

    -- Wait 20 clock cycles, plus a little more ( don't want to change
    -- on the rising edge of data )
    --
    wait for 20 * 2 * T_pw + 5 ns;

    -- Request to send a light wave
    --
    tx <= '1';
    wait for 2 * T_pw;
    tx <= '0';

    -- Wait 2 clock pulses, don't bother trying to match clock edges,
    -- since this is simulating an asynchronous input
    --
    wait for 2 * 2 * T_pw;

    -- Set the input high (object detected)
    --
    input <= '1';
    wait for 2 * T_pw;
    input <= '0';

    wait;

	end process input_control;	

end mixed;
