-------------------------------------------------
-- motor_driver_tb.vhd
--
-- Author:   Steve Dillen
-- Date:     Oct 30, 2000 
-- Course:   EE552
-- Desc:
--
-- This testbench will test the motor driver circuit
--

library ieee;
use ieee.std_logic_1164.all;

-- Test Bench
--
entity motor_driver_tb is
end motor_driver_tb;

architecture mixed of motor_driver_tb is

	component motor_driver is

    port( clock      : in  std_logic;
          reset      : in  std_logic;
          direction  : in  std_logic;
          pwm_signal : in  std_logic;
          stop       : in  std_logic;
          forward    : out std_logic;
          reverse    : out std_logic;
          enable     : out std_logic
        );

  end component motor_driver;

  -- Clock period / 2
  --
  constant T_pw       : time     := 20 ns;

  -- Generated control signals
  --
  signal clock        : std_logic;
  signal reset        : std_logic;

  -- Generated data signals
  signal direction    : std_logic;
  signal pwm_signal   : std_logic;
  signal stop         : std_logic;
  signal forward      : std_logic;
  signal reverse      : std_logic;
  signal enable       : std_logic;

  -- Generate delayed signals
  signal delayed_pwm       : std_logic;
  signal delayed_direction : std_logic;
  signal delayed_stop      : std_logic;

begin

  -- Wire the delayed signals
  --
  delayed_pwm       <= pwm_signal after 5 ns;
  delayed_direction <= direction  after 5 ns;
  delayed_stop      <= stop       after 5 ns;

  -- Configure a photo_reflector
  --
	motor : motor_driver port map (
                                  clock      => clock,
                                  reset      => reset,
                                  direction  => delayed_direction,
                                  pwm_signal => delayed_pwm,
                                  stop       => delayed_stop,
                                  forward    => forward,
                                  reverse    => reverse,
                                  enable     => enable
                                );

	-- clock generator
  --
	clock_gen : process
	begin

		clock <= '0';
    wait for T_pw;
    clock <= '1';
    wait for T_pw;

	end process clock_gen;

  -- Generate a PWM signal
  --
  pwm_gen : process
  begin

    pwm_signal <= '0';
    wait for 20 * T_pw;
    pwm_signal <= '1';
    wait for 2 * T_pw;

  end process pwm_gen;

	-- process to control the reset signal
  --
	reset_control : process
	begin
		
		-- Reset the circuit
    --
		reset <= '1';
		wait for 80 ns;

    -- Take out of reset
    --
		reset <= '0';
		wait for 1250 ns;

    -- Reset the circuit to show synchronized reset
    --
		reset <= '1';
		wait for 250 ns;

    -- Keep out of reset for the rest of the simulation
    --
    reset <= '0';
		wait;

	end process reset_control;

  -- Generate a motor stop
  --
  stop_gen : process
  begin

    -- Generally motor's aren't stopped
    --
    stop <= '0';
    wait for 10 * 2 * T_pw;

    -- Stop the motors
    --
    stop <= '1';
    wait for 4 * 2 * T_pw;

    stop <= '0';

    -- That is it for this process
    --
    wait;

  end process stop_gen;

	-- process to control direction
  --
	input_control : process
	begin

    -- Start with forward direction
    --
    direction <= '1';

    -- Wait 10 clock cycles, plus a little more ( don't want to change
    -- on the rising edge of data )
    --
    wait for 10 * 2 * T_pw;

    -- Reverse direction
    --
    direction <= '0';

    -- Wait 10 clock cycles, plus a little more ( don't want to change
    -- on the rising edge of data )
    --
    wait for 10 * 2 * T_pw;

	end process input_control;

--  verification : process
--  begin
--  end process;

end mixed;
