-- Mazebot Project
-- EE 552 Fall 2000
--
-- Authors:
-- Steve Dillen 225760
-- Farrah Rashid 354698
--
-- November 14, 2000
--
-- motor_control_test.vhd

library ieee;
use ieee.std_logic_1164.all;

package test_pkg is

	constant busWidth       : positive := 4; 
  constant numberOfMotors : positive := 2;

	component motor_control is

		port    ( clock          : in  std_logic;
       		    reset          : in  std_logic;
          	  velocity       : in  std_logic_vector( numberOfMotors * busWidth - 1 downto 0 );
            	valid          : in  std_logic_vector( numberOfMotors - 1 downto 0 );
            	pwm_signal     : out std_logic_vector( numberOfMotors - 1 downto 0 )
          );

	end component motor_control;

end package test_pkg;

library ieee;
use ieee.std_logic_1164.all;
library work;
use work.test_pkg.all;

entity motor_control_test is
end motor_control_test;

architecture mixed of motor_control_test is

constant T_pw									: time	:= 20 ns;
signal clock, reset						: std_logic;
signal internal_velocity			: std_logic_vector( numberOfMotors * busWidth - 1 downto 0 );
signal delayed_velocity				: std_logic_vector( numberOfMotors * busWidth - 1 downto 0 );
signal internal_valid					: std_logic_vector( numberOfMotors - 1 downto 0);
signal delayed_valid					: std_logic_vector( numberOfMotors - 1 downto 0);
signal internal_pwm						: std_logic_vector( numberOfMotors - 1 downto 0);
signal delayed_pwm						: std_logic_vector( numberOfMotors - 1 downto 0);

begin

	delayed_velocity <= internal_velocity after 2 ns;
	delayed_valid		 <= internal_valid after 2 ns;
	delayed_pwm			 <= internal_pwm after 2 ns;

	control_part		: component motor_control port map (
										clock				=> clock,
										reset				=> reset,
										velocity		=> delayed_velocity,
										valid				=> delayed_valid,
										pwm_signal	=> internal_pwm);


	clock_gen				:	process
	begin
		
		clock <= '1' after T_pw, '0' after 2*T_pw;
		wait for 2*T_pw;

	end process clock_gen;

	control					: process
	begin

		reset <= '1';
		wait for 250 ns;
		reset <= '0';
		wait for 230 ns;

		internal_velocity <= "00110110";
		internal_valid		<= "11";

		wait for 120 ns;

		internal_velocity <= "11000001";
		internal_valid		<= "01";

		wait for 120 ns;

	end process control;

end mixed;
