-------------------------------------------------
-- frequency_divider_tb.vhd
--
-- Author:   Steve Dillen
-- Date:     Oct 31, 2000 
-- Course:   EE552
-- Desc:
--
-- This testbench will test the frequency divider
-- so that different resolution of enable signals
-- can be achieved.
--

library ieee;
use ieee.std_logic_1164.all;

-- Test Bench
--
entity frequency_divider_tb is
end frequency_divider_tb;

architecture mixed of frequency_divider_tb is

	component frequency_divider

    port    ( clock     : in  std_logic;
              reset     : in  std_logic;
              divisor   : in  std_logic_vector( 15 downto 0 );
              frequency : out std_logic
            );

  end component frequency_divider;

  -- Clock period / 2
  --
  constant T_pw     : time := 20 ns;

  -- Generated control signals
  --
  signal clock      : std_logic;
  signal reset      : std_logic;

  -- Generated data signals
  signal divisor    : std_logic_vector( 15 downto 0 );
  signal frequency  : std_logic;

begin

  -- Configure a photo_reflector
  --
	divider : frequency_divider port    map (
                                            clock     => clock,
                                            reset     => reset,
                                            divisor   => divisor,
                                            frequency => frequency
                                          );

	-- clock generator
  --
	clock_gen : process
	begin

		clock <= '0';
    wait for T_pw;
    clock <= '1';
    wait for T_pw;

	end process clock_gen;

	-- process to control the reset signal
  --
	reset_control : process
	begin
		
		-- Reset the circuit
    --
		reset <= '1';
		wait for 80 ns;

    -- Take out of reset
    --
		reset <= '0';
		wait for 1 us;

    -- Reset the circuit to show synchronized reset
    --
		reset <= '1';
		wait for 250 ns;

    -- Keep out of reset for the rest of the simulation
    --
    reset <= '0';
		wait;

	end process reset_control;

	-- process to control data lines
  --
	input_control : process
	begin

    divisor <= "0000000000000010";

    -- Come out of reset
    --
    wait for 80 ns;

    -- See some pulses
    --
    wait for 16 * 2 * T_pw;

    -- Change the frequency
    --
    divisor <= "0000000000001000";

    wait;

	end process input_control;	

end mixed;
