-------------------------------------------------
-- duty_splitter_tb.vhd
--
-- Author:   Steve Dillen
-- Date:     Oct 31, 2000 
-- Course:   EE552
-- Desc:
--
-- This testbench will test the duty splitter which accepts a duty
-- rate and splits it into an on count and an off count
--

-- Include ieee std_logic types
--
library ieee;
use ieee.std_logic_1164.all;

-- Test Bench
--
entity duty_splitter_tb is
end duty_splitter_tb;

architecture mixed of duty_splitter_tb is

  component duty_splitter is

    port    ( clock      : in  std_logic;
              reset      : in  std_logic;
              duty_cycle : in  std_logic_vector( 1 downto 0 );
              on_duty    : out std_logic_vector( 1 downto 0 );
              off_duty   : out std_logic_vector( 1 downto 0 )
            );

  end component duty_splitter;

  -- Clock period / 2
  --
  constant T_pw       : time     := 20 ns;
  constant delay_time : time     := 10 ns;
  constant busWidth   : positive := 2;

  -- Generated control signals
  --
  signal clock        : std_logic;
  signal reset        : std_logic;

  -- Generated input signals
  --
  signal duty_cycle : std_logic_vector( 1 downto 0 );
  
  -- Delay the inputs so they aren't changing on the rising edge of the clock
  -- 
  signal duty_cycle_delayed : std_logic_vector( 1 downto 0 );

  -- Outputs don't need to be delayed.
  --
  signal on_duty  : std_logic_vector( 1 downto 0 );
  signal off_duty : std_logic_vector( 1 downto 0 );

begin

  -- Delay the inputs
  --
  duty_cycle_delayed <= duty_cycle after delay_time;

  -- Configure a pwm
  --
	reflector : duty_splitter port map (
                                       clock      => clock,
                                       reset      => reset,
                                       duty_cycle => duty_cycle_delayed,
                                       on_duty    => on_duty,
                                       off_duty   => off_duty
                                     );

	-- clock generator
  --
	clock_gen : process
	begin

		clock <= '0';
    wait for T_pw;
    clock <= '1';
    wait for T_pw;

	end process clock_gen;

	-- process to control the reset signal
  --
	reset_control : process
	begin
		
		-- Reset the circuit
    --
		reset <= '1';
		wait for 4 * T_pw;

    -- Take out of reset
    --
		reset <= '0';
		wait for 76 * T_pw;

    -- Reset the circuit to show synchronized reset
    --
		reset <= '1';
		wait for 10 * T_pw;

    -- Keep out of reset for the rest of the simulation
    --
    reset <= '0';
		wait;

	end process reset_control;

	-- process to control data inputs
  --
	input_control : process
	begin

    -- Start with 0's on the lines
    --
    duty_cycle <= ( others => '0' );

    -- Wait for a few clock cycles
    --
    wait for 10 * 2 * T_pw;

    -- Change to a duty cycle of 1
    --
    duty_cycle(0) <= '1';
    wait for 10 * 2 * T_pw;

    -- Change to a duty cycle of 3
    --
    duty_cycle(1) <= '1';
    wait for 10 * 2 * T_pw;

    -- Change to a duty cycle of 2
    --
    duty_cycle(0) <= '0';
    wait for 10 * 2 * T_pw;

    -- Leave on to see synchronous reset
    --
    wait;

	end process input_control;	

end mixed;
