-------------------------------------------------
-- pwm_generator_tb.vhd
--
-- Author:   Steve Dillen
-- Date:     November 15, 2000 
-- Course:   EE552
-- Desc:
--
-- This testbench will test the latch_rate module.  This module
-- acts as a d flip flop, except on reset it pre-loads instead
-- of clears.
--

-- Include ieee std_logic types
--
library ieee;
use ieee.std_logic_1164.all;

-- Test Bench
--
entity duty_rate_generator_tb is
end duty_rate_generator_tb;

architecture mixed of duty_rate_generator_tb is

  component duty_rate_generator is

    port    ( clock      : in  std_logic;
              reset      : in  std_logic;
              adjustment : in  std_logic_vector( 2 downto 0 );
              valid_in   : in  std_logic;
              duty_rate  : out std_logic_vector( 2 downto 0 )
            );

  end component duty_rate_generator;

  -- Clock period / 2
  --
  constant T_pw       : time     := 20 ns;
  constant delay_time : time     := 10 ns;
  constant busWidth   : positive := 2;

  -- Generated control signals
  --
  signal clock        : std_logic;
  signal reset        : std_logic;

  -- Generated input signals
  --
  signal adjustment : std_logic_vector( 2 downto 0 );
  signal valid_in   : std_logic;
  
  -- Delay the inputs so they aren't changing on the rising edge of the clock
  -- 
  signal adjustment_delayed : std_logic_vector( 2 downto 0 );
  signal valid_in_delayed   : std_logic;

  -- Outputs don't need to be delayed.
  --
  signal duty_rate : std_logic_vector( 2 downto 0 );

begin

  -- Delay the inputs
  --
  adjustment_delayed <= adjustment after delay_time;
  valid_in_delayed   <= valid_in   after delay_time;

  -- Configure a pwm
  --
	dut : duty_rate_generator port map (
                                       clock      => clock,
                                       reset      => reset,
                                       adjustment => adjustment_delayed,
                                       valid_in   => valid_in_delayed,
                                       duty_rate  => duty_rate
                                     );

	-- clock generator
  --
	clock_gen : process
	begin

		clock <= '0';
    wait for T_pw;
    clock <= '1';
    wait for T_pw;

	end process clock_gen;

	-- process to control the reset signal
  --
	reset_control : process
	begin
		
		-- Reset the circuit
    --
		reset <= '1';
		wait for 4 * T_pw;

    -- Take out of reset
    --
		reset <= '0';
		wait for 76 * T_pw;

    -- Reset the circuit to show synchronized reset
    --
		reset <= '1';
		wait for 10 * T_pw;

    -- Keep out of reset for the rest of the simulation
    --
    reset <= '0';
		wait;

	end process reset_control;

	-- process to control data inputs
  --
	input_control : process
	begin

    -- Start with 0's on the lines
    --
    adjustment <= ( others => '0' );
    valid_in   <= '0';

    -- Wait for a few clock cycles
    --
    wait for 10 * 2 * T_pw;

    -- Change input
    --
    adjustment <= "011";
    wait for 10 * 2 * T_pw;

    -- Change input with enable
    --
    valid_in <= '1';
    wait for 2 * T_pw;
    valid_in <= '0';

    wait for 10 * 2 * T_pw;

    -- Change to a duty cycle of 2
    --
    adjustment <= "110";

    -- Pulse Valid
    --
    valid_in <= '1';
    wait for 2 * T_pw;
    valid_in <= '0';

    -- Leave on to see synchronous reset
    --
    wait;

	end process input_control;	

end mixed;
