-- Mazebot Project
-- EE 552 Fall 2000
--
-- Authors:
-- Steve Dillen 225760
-- Farrah Rashid 354698
--
-- November 24, 2000
--
-- controlbot2_test.vhd

library ieee;
use ieee.std_logic_1164.all;

package test_pkg is

	component controlbot is

		port ( 
        -- Control signals
        --
        clock            : in  std_logic;
        reset_signal     : in  std_logic;

        -- Shaft encoder signals
        --
        reflection       : in  std_logic_vector( 2 - 1 downto 0 );

        -- Motor signals
        --
        forward          : out std_logic_vector( 2 - 1 downto 0 );
        reverse          : out std_logic_vector( 2 - 1 downto 0 );
        enable           : out std_logic_vector( 2 - 1 downto 0 );
 
        -- Debug signals
        --
        displayMSN       : out std_logic_vector( 7 downto 0 );
        displayLSN       : out std_logic_vector( 7 downto 0 );

        res              : out std_logic;
        valid_out        : out std_logic_vector( 2 - 1 downto 0 )
      );

		end component controlbot;

end package test_pkg;

library ieee;
use ieee.std_logic_1164.all;
library work;
use work.test_pkg.all;

entity controlbot_test2 is
end controlbot_test2;

architecture mixed of controlbot_test2 is

constant T_pw									: time	:= 20 ns;
signal clock, reset						: std_logic;
signal internal_reflection		: std_logic_vector	( 2 - 1 downto 0 ); 
signal delayed_reflection			: std_logic_vector	( 2 - 1 downto 0 );
signal internal_forward				: std_logic_vector( 2 - 1 downto 0 );
signal internal_reverse				: std_logic_vector( 2 - 1 downto 0 );
signal internal_enable				: std_logic_vector( 2 - 1 downto 0 );
signal internal_displayMSN		: std_logic_vector(7 downto 0);
signal internal_displayLSN		: std_logic_vector(7 downto 0);
signal internal_res						:	std_logic;
signal internal_valid_out			: std_logic_vector( 2 - 1 downto 0 );

begin

	delayed_reflection <= internal_reflection after 10 ns;

	controlbot_part			:	component controlbot port map (

												clock					=> clock,
												reset_signal	=> reset,
												reflection		=> delayed_reflection,
												forward				=> internal_forward,
												reverse				=> internal_reverse,
												enable				=> internal_enable,
												displayMSN		=> internal_displayMSN,
												displayLSN		=> internal_displayLSN,
												res						=> internal_res,
												valid_out			=> internal_valid_out );

	clock_gen				:	process
	begin
		
		clock <= '0';
		wait for T_pw;
		clock <= '1';
		wait for T_pw;
		
	end process clock_gen;

	reset_gen				: process
	begin

		reset <= '1';
		wait for 250 ns;
		reset	<= '0';
		wait for 3 us;

	end process reset_gen;

	control					: process
	begin

		internal_reflection <= "00";
		wait for 510 ns;

		-- reflection rate is the same

		loop
			internal_reflection(0) <= not internal_reflection(0);
			internal_reflection(1) <= not internal_reflection(1);
			wait for 40 ns;
			internal_reflection(0) <= not internal_reflection(0);
			wait for 40 ns;
			exit when reset = '1';
		end loop;

	end process control;

end mixed;


	
