-- Mazebot Project
-- EE552 Fall 2000
--
-- Authors:
-- Steve Dillen 225760
-- Farrah Rashid 354698
--
-- Novermber 22, 2000
--
-- restart.vhd
-- This file implements a debouncer for the reset push button

library ieee;
use ieee.std_logic_1164.all;

entity restart is

	port	(	clock		: in std_logic;
					input		: in std_logic;
					output	: out std_logic );

end restart;

architecture behavioural of restart is

	constant busWidth				: positive			:= 16;
	signal check 						: std_logic;
	signal reset 						: std_logic;
	signal internal_divisor : std_logic_vector (busWidth - 1 downto 0) := "0110000110101000";
	signal check_prior			: std_logic;

	component frequency_divider

		generic ( busWidth : positive := 16 );

  	port    ( clock     : in  std_logic;
    	        reset     : in  std_logic;
      	      divisor   : in  std_logic_vector( busWidth - 1 downto 0 );
        	    frequency : out std_logic
         	 );
	
	end component frequency_divider;

begin

	internal_divisor <= "0110000110101000";

	process

	begin

		if rising_edge (clock) then

			if (check_prior = '0' and check = '1') then
				
				if input = '0' then -- reset button is active low
					output <= '1';
				else
					output <= '0';
				end if;

			else
			
				check_prior <= check;

			end if;

		end if;

	end process;

	reset <= not input;

	counter	: frequency_divider 
		generic map (busWidth => 16)
		port map		(clock	=> clock,
								 reset	=> reset,
						 		 divisor => internal_divisor,
								 frequency => check);

end behavioural;
			
