-- Mazebot Project
-- EE552 Fall 2000
--
-- Authors:
-- Steve Dillen 225760
-- Farrah Rashid 354698
--
-- November 13, 2000
--
-- pwm_generator.vhd
-- This module generates the PWM signal for the specified duty cycle
--

-- Include ieee std types
--
library ieee;
use ieee.std_logic_1164.all;

-- Include Mazebot configuration
--
library work;
use work.config.all;

entity pwm_generator is

  generic ( busWidth   : positive := 4 );

  port    ( clock      : in  std_logic;
            reset      : in  std_logic;
            duty_cycle : in  std_logic_vector( busWidth - 1 downto 0 );
            pwm_signal : out std_logic
          );

end pwm_generator;

architecture RTL of pwm_generator is

  component duty_splitter is

    generic ( busWidth   : positive );

    port    ( clock      : in  std_logic;
              reset      : in  std_logic;
              duty_cycle : in  std_logic_vector( busWidth - 1 downto 0 );
              on_duty    : out std_logic_vector( busWidth - 1 downto 0 );
              off_duty   : out std_logic_vector( busWidth - 1 downto 0 )
            );

  end component duty_splitter;

  component duty_counter is

    generic ( busWidth   : positive );

    port    ( clock      : in  std_logic;
              reset      : in  std_logic;
              duty_cycle : in  std_logic_vector( busWidth - 1 downto 0 );
              match      : out std_logic
            );

  end component duty_counter;

  component pwm is

    port ( clock      : in  std_logic;
           reset      : in  std_logic;
           state      : in  std_logic;
           pwm_signal : out std_logic
         );

  end component pwm;
 
  component mazebot_mux2 is

    generic ( busWidth : positive );

    port    ( clock   : in  std_logic;
              reset   : in  std_logic;
              control : in  std_logic;
              input_0 : in  std_logic_vector( busWidth - 1 downto 0 );
              input_1 : in  std_logic_vector( busWidth - 1 downto 0 );
              output  : out std_logic_vector( busWidth - 1 downto 0 )
            );

  end component mazebot_mux2;

  component mazebot_dff is

    port    ( clock  : in  std_logic;
              reset  : in  std_logic;
              enable : in  std_logic;
              d      : in  std_logic;
              q      : out std_logic
            );

  end component mazebot_dff;

  -- Declare internal connection signals
  --
  signal internal_on_duty    : std_logic_vector( busWidth - 1 downto 0 );
  signal internal_off_duty   : std_logic_vector( busWidth - 1 downto 0 );
  signal internal_match_duty : std_logic_vector( busWidth - 1 downto 0 );
  signal internal_match      : std_logic;
  signal internal_staten     : std_logic;

  -- Hold the current state of the PWM signal
  --
  signal state               : std_logic;

begin

  -- Split the duty cycle into on duty and off duty
  --
  split : duty_splitter generic map ( busWidth   => busWidth )
                        port    map (
                                      clock      => clock, 
                                      reset      => reset,
                                      duty_cycle => duty_cycle,
                                      on_duty    => internal_on_duty,
                                      off_duty   => internal_off_duty
                                    );

  -- Generate the MUX for the on and off duty count
  --
  on_off_mux : mazebot_mux2 generic map ( busWidth => busWidth )
                            port    map ( 
                                          clock    => clock,
                                          reset    => reset,
                                          control  => state,
                                          input_0  => internal_off_duty,
                                          input_1  => internal_on_duty,
                                          output   => internal_match_duty
                                        );

  -- Generate the match detection
  --
  match_duty : duty_counter generic map ( busWidth   => busWidth )
                            port    map (
                                          clock      => clock,
                                          reset      => reset,
                                          duty_cycle => internal_match_duty,
                                          match      => internal_match
                                        );

  -- Switch the state of the duty cycle
  --
  switch : mazebot_dff port map (
                                  clock  => clock,
                                  reset  => reset,
                                  enable => internal_match,
                                  d      => internal_staten,
                                  q      => state
                                );

  -- Generate the PWM signal
  --
  generate_pwm : pwm port map (
                                clock      => clock,
                                reset      => reset,
                                state      => state,
                                pwm_signal => pwm_signal
                              );

  -- Hard-wire internal signals
  --
  internal_staten <= not state;

end RTL;
