-- Mazebot Project
-- EE552 Fall 2000
--
-- Authors:
-- Steve Dillen 225760
-- Farrah Rashid 354698
--
-- October 9, 2000
--
-- pwm.vhd
-- This file implements a PWM signal for a given input duty state
--

library ieee;
use ieee.std_logic_1164.all;

entity pwm is

  port ( clock      : in  std_logic;
         reset      : in  std_logic;
         state      : in  std_logic;
         pwm_signal : out std_logic
       );

end pwm;

architecture RTL of pwm is

begin

  gen : process

  begin

    -- Synchronize on rising edge of the clock
    --
    wait until rising_edge( clock );

    -- Synchronous reset
    --
    if reset = '1' then

      pwm_signal <= '0';

    else

      -- Don't just use state here so we don't pass along don't cares,
      -- weak signals, or unknowns.  The only time we want the PWM going
      -- to a '1' is when state is a '1'.
      --
      if state = '1' then

        pwm_signal <= '1';

      else

        pwm_signal <= '0';

      end if;

    end if;

  end process gen;

end RTL;
