-- Mazebot Project
-- EE552 Fall 2000
--
-- Authors:
-- Steve Dillen 225760
--
-- October 9, 2000
--
-- photo_reflector.vhd
-- This file implements a synchronization circuit for the photo-reflector's.
-- 

-- Include the standard logic types.
--
library ieee;
use ieee.std_logic_1164.all;

-- Include the Mazebot configuration and useful types
--
library work;
use work.config.all;

-- Define the photo-reflector as an simple input / output device
--
entity photo_reflector is

  port( clock        : in  std_logic;
        reset        : in  std_logic;
        rx           : out std_logic;
        input        : in  std_logic
      );

end photo_reflector;

-- Allow for expansion architectures of different photo_reflectors

--
architecture Hamamatsu_p5587 of photo_reflector is

  component preset_synchronizer is

    generic( numberOfLevels : positive );

    port   ( clock        : in  std_logic;
             preset       : in  std_logic;
             input        : in  std_logic;
             output       : out std_logic
           );

  end component preset_synchronizer;

begin

  -- Synchronize the input, and feed it to the output
  --
  sync_input  : preset_synchronizer generic map ( numberOfLevels => 2 )
                                    port    map ( 
                                                  clock          => clock,
                                                  preset         => reset,
                                                  input          => input,
                                                  output         => rx        
                                                );

end Hamamatsu_p5587;
