-- Mazebot Project
-- EE552 Fall 2000
--
-- Authors:
-- Steve Dillen 225760
-- Farrah Rashid 354698
--
-- October 9, 2000
--
-- motor_control.vhd
-- This file implements a motor driver circuit to connect the PWM signal to
-- motor driver circuit board.
--
-- direction - 0 => reverse
--             1 => forward
-- 

-- Include the standard logic types.
--
library ieee;
use ieee.std_logic_1164.all;

-- Include the Mazebot configuration and useful types
--
library work;
use work.config.all;

-- Define the motor driver to match the schematic in the design document
--
entity motor_driver is

  port( clock      : in  std_logic;
        reset      : in  std_logic;
        direction  : in  std_logic;
        pwm_signal : in  std_logic;
        stop       : in  std_logic;
        forward    : out std_logic;
        reverse    : out std_logic;
        enable     : out std_logic
      );

end motor_driver;

-- Allow for expansion architectures of different motor driver boards
--
architecture L298 of motor_driver is

  signal sync_forward : std_logic;
  signal sync_reverse : std_logic;
  signal sync_enable  : std_logic;

begin

  -- Enable will be wired directly to the reset so that the motor's
  -- will be shut-off during system start-up
  --
  sync_enable  <= not reset;

  -- Motor forward when reset is high, and direction is high
  --
  sync_forward <= (pwm_signal and     direction and not reset) or stop;

  -- Motor reverse when reset is high, and direction is low
  --
  sync_reverse <= (pwm_signal and not direction and not reset) or stop;

  -- Synchronize the outputs from the circuit
  --
  sforward : synchronizor generic map (
                                        numberOfLevels => 1
                                      )
                          port    map (
                                        clock          => clock,
                                        reset          => reset,
                                        input          => sync_forward,
                                        output         => forward
                                      );
  
  sreverse : synchronizor generic map (
                                        numberOfLevels => 1
                                      )
                          port    map (
                                        clock          => clock,
                                        reset          => reset,
                                        input          => sync_reverse,
                                        output         => reverse
                                      );

  senable  : synchronizor generic map (
                                        numberOfLevels => 1
                                      )
                          port    map (
                                        clock          => clock,
                                        reset          => reset,
                                        input          => sync_enable,
                                        output         => enable
                                      );

end L298;
