-- Mazebot Project
-- EE552 Fall 2000
--
-- Authors:
-- Steve Dillen 225760
--
-- November 27, 2000
--
-- milli_counter.vhd
-- This file implements a millisecond counter so you can count the number
-- of millisecond pulses
--

-- Include IEEE std_logic_1164
--
library ieee;
use ieee.std_logic_1164.all;

-- Include Controlbot configuration
--
library work;
use work.config.all;

entity milli_counter is

  generic ( busWidth        : positive := 4;
            resolutionWidth : positive := 4
          );

  port    ( clock           : in  std_logic;
            reset           : in  std_logic;
            resolution      : in  std_logic_vector( resolutionWidth - 1 downto 0 );
            count           : in  std_logic_vector( busWidth - 1 downto 0 );
            valid_out       : out std_logic
          );

end milli_counter;

architecture RTL of milli_counter is

  component frequency_divider is

    generic ( busWidth : positive );

    port    ( clock     : in  std_logic;
              reset     : in  std_logic;
              divisor   : in  std_logic_vector( busWidth - 1 downto 0 );
              frequency : out std_logic
            );

  end component frequency_divider;

  component controlbot_counter is

    generic ( busWidth : positive );

    port    ( clock    : in  std_logic;
              reset    : in  std_logic;
              enable   : in  std_logic;
              count    : out std_logic_vector( busWidth - 1 downto 0 )
            );

  end component controlbot_counter;

  signal ms_frequency  : std_logic;
  signal counter_reset : std_logic;
  signal current_count : std_logic_vector( busWidth - 1 downto 0 );
  signal valid_count   : std_logic;

begin

  ms_count : frequency_divider generic map ( busWidth  => resolutionWidth )
                               port    map ( 
                                             clock     => clock,
                                             reset     => reset,
                                             divisor   => resolution,
                                             frequency => ms_frequency
                                           );


  -- Start counting number of milli-second pulses
  --
  calc : controlbot_counter generic map ( busWidth => busWidth )
                            port    map (
                                          clock    => clock,
                                          reset    => counter_reset,
                                          enable   => ms_frequency,
                                          count    => current_count
                                        );

  compare    : lpm_compare generic map ( lpm_width       => busWidth )
                           port    map ( 
                                         dataa           => current_count,
                                         datab           => count,
                                         agb             => valid_count 
                                       );

  counter_reset <= reset or valid_count;

  -- Synchronize the output
  --
  flop : synchronizor generic map ( numberOfLevels => 1 )
                      port    map (
                                    clock          => clock,
                                    reset          => reset,
                                    input          => valid_count,
                                    output         => valid_out
                                  );

end RTL;

