-- Mazebot Project
-- EE552 Fall 2000
--
-- Authors:
-- Steve Dillen 225760
-- Farrah Rashid 354698
--
-- November 13, 2000
--
-- mazebot_mux2.vhd
-- This module generates a 2 input n bit wide mux
--

-- Include ieee std types
--
library ieee;
use ieee.std_logic_1164.all;

-- Include Mazebot configuration
--
library work;
use work.config.all;

entity mazebot_mux2 is

  generic ( busWidth : positive := 2 );

  port    ( clock   : in  std_logic;
            reset   : in  std_logic;
            control : in  std_logic;
            input_0 : in  std_logic_vector( busWidth - 1 downto 0 );
            input_1 : in  std_logic_vector( busWidth - 1 downto 0 );
            output  : out std_logic_vector( busWidth - 1 downto 0 )
          );

end mazebot_mux2;

architecture RTL of mazebot_mux2 is

begin

  -- Generate the MUX for the on and off duty count
  --
  on_off_mux : process
  begin

    -- Synchronize on rising edge of the clock
    --
    wait until rising_edge( clock );

    -- Synchronous reset, send out a 0's on the output
    --
    if reset = '1' then

      output <= ( others => '0' );

    else

      -- If the control is a zero, send out the zero stream
      --
      if control = '0' then

        output <= input_0;

      elsif control = '1' then

        -- Control is one, send out the one stream
        --
        output <= input_1;

      else

        -- Control is a weak signal, or unknown, send out zero's
        --
        output <= ( others => '0' );

      end if;

    end if;

  end process on_off_mux;

end RTL;
