-- Mazebot Project
-- EE552 Fall 2000
--
-- Authors:
-- Steve Dillen 225760
--
-- October 9, 2000
--
-- mazebot_dff.vhd
-- Implements a DFF with an enable
--
-- 

-- Include the standard logic types.
--
library ieee;
use ieee.std_logic_1164.all;

-- Include the Mazebot configuration and useful types
--
library work;
use work.config.all;

-- Define the mazebot dff
--
entity mazebot_dff is

  port    ( clock  : in  std_logic;
            reset  : in  std_logic;
            enable : in  std_logic;
            d      : in  std_logic;
            q      : out std_logic
          );

end mazebot_dff;

architecture RTL of mazebot_dff is

begin

  flop : process
  begin

    wait until rising_edge( clock );

    if reset = '1' then

      q <= '0';

    else

      if enable = '1' then

        q <= d;

      end if;

    end if;

  end process flop;

end RTL;
