-- Mazebot Project
-- EE552 Fall 2000
--
-- Authors:
-- Steve Dillen 225760
-- Farrah Rashid 354698
--
-- November 13, 2000
--
-- latch_rate.vhd
-- This module latches the base rate on reset, and acts as a D
-- Flip-flop otherwise.  The busWidth has to be 3 or greater.
--

-- Include ieee std types
--
library ieee;
use ieee.std_logic_1164.all;

-- Include Mazebot configuration
--
library work;
use work.config.all;

entity latch_rate is

  generic ( busWidth   : positive := 16 );

  port    ( clock      : in  std_logic;
            reset      : in  std_logic;
            d          : in  std_logic_vector( busWidth - 1 downto 0 );
            initial    : in  std_logic_vector( busWidth - 2 downto 0 );
            valid_in   : in  std_logic;
            q          : out std_logic_vector( busWidth - 1 downto 0 )
          );

end latch_rate;

architecture RTL of latch_rate is

begin

  latch_duty_rate : process
  begin

    wait until rising_edge( clock );

    if reset = '1' then

      q( busWidth - 2 downto 0 ) <= initial;
      q( busWidth - 1 )          <= '0';

    else

      if valid_in = '1' then

        q         <= d;

      end if;

    end if;

  end process latch_duty_rate;

end RTL;
