-- Mazebot Project
-- EE552 Fall 2000
--
-- Authors:
-- Steve Dillen 225760
--
-- November 10, 2000
--
-- integral.vhd
-- This module will control the speed of the motors.  The inputs to this
-- module will be either the actual velocity of the motors, and the velocity
-- we would like to control to.
--

-- Include the IEEE standard types
--
library ieee;
use ieee.std_logic_1164.all;

-- Include the mazebot configuration
--
library work;
use work.config.all;

entity integral is

  generic ( busWidth         : positive := 4;
            extendedBusWidth : positive := 5
          );

  port    ( clock            : in  std_logic;
            reset            : in  std_logic;
            a                : in  std_logic_vector( busWidth - 1 downto 0 );
            b                : in  std_logic_vector( busWidth - 1 downto 0 );
            valid_in         : in  std_logic;
            valid_out        : out std_logic;
            control          : out std_logic_vector( busWidth downto 0 )
          );        

end integral;

-- Different control schemes can be implemented in different
-- architectures
--
architecture RTL of integral is

  signal internal_difference : std_logic_vector( busWidth downto 0 );
  signal extended_a          : std_logic_vector( busWidth downto 0 );
  signal extended_b          : std_logic_vector( busWidth downto 0 );
  signal internal_integral   : std_logic_vector( busWidth downto 0 );
  signal subtract            : std_logic;
  signal valid_in_delayed_1  : std_logic;

begin

  extended_a( busWidth ) <= '0';
  extended_b( busWidth ) <= '0';
  subtract               <= '0';

  extended_a( busWidth - 1 downto 0 ) <= a;
  extended_b( busWidth - 1 downto 0 ) <= b;

  -- Configure Valid levels
  --
  delay1 : synchronizor generic map ( numberOfLevels => 1 )
                        port    map (
                                      clock          => clock,
                                      reset          => reset,
                                      input          => valid_in,
                                      output         => valid_in_delayed_1
                                    );
    
  -- Subtract data a from data b
  --
  add_bias : lpm_add_sub generic map (
                                       lpm_width          => extendedBusWidth,
                                       lpm_representation => "SIGNED",
                                       lpm_pipeline       => 1
                                     )
                         port    map (
                                       dataa              => extended_a,
                                       datab              => extended_b,
                                       aclr               => reset,
                                       clock              => clock,
                                       add_sub            => subtract,
                                       clken              => valid_in,
                                       result             => internal_difference
                                     );

  -- Integrate the results
  --                                       
  integrate : lpm_add_sub generic map (
                                        lpm_width          => extendedBusWidth,
                                        lpm_representation => "SIGNED",
                                        lpm_pipeline       => 1
                                      )
                          port    map (
                                        dataa              => internal_difference,
                                        datab              => internal_integral,
                                        aclr               => reset,
                                        clock              => clock,
                                        clken              => valid_in_delayed_1,
                                        result             => internal_integral
                                      );

  -- Wire control output to integral
  --
  control <= internal_integral;

  -- Send out the valid out signal
  --
  flop : synchronizor generic map ( numberOfLevels => 2 )
                      port    map (
                                    clock          => clock,
                                    reset          => reset,
                                    input          => valid_in,
                                    output         => valid_out
                                  );

end RTL;
