-- Mazebot Project
-- EE552 Fall 2000
--
-- Authors:
-- Steve Dillen 225760
--
-- November 10, 2000
--
-- input.vhd
-- This module takes the inputs to the fuzzy controller, and calculates
-- the difference in the velocity, and the delta in the previous difference.
--

-- Include the IEEE standard types
--
library ieee;
use ieee.std_logic_1164.all;

-- Include the mazebot configuration
--
library work;
use work.config.all;

entity input is

  generic ( busWidth         : positive := 4; 

            -- Due to a compile bug with MaxPlus2, this must be specified to be
            -- busWidth + 1.
            --
            extendedBusWidth : positive := 5
          );

  port    ( clock            : in  std_logic;
            reset            : in  std_logic;
            data_a           : in  std_logic_vector( busWidth - 1 downto 0 );
            data_b           : in  std_logic_vector( busWidth - 1 downto 0 );
            reference        : in  std_logic_vector( busWidth - 1 downto 0 );            
            valid_in         : in  std_logic;
            valid_out        : out std_logic;
            difference       : out std_logic_vector( busWidth downto 0 );
            integration      : out std_logic_vector( busWidth downto 0 )
          );        

end input;

architecture massage of input is

  component integral is

    generic ( busWidth         : positive;
              extendedBusWidth : positive
            );

    port    ( clock            : in  std_logic;
              reset            : in  std_logic;
              a                : in  std_logic_vector( busWidth - 1 downto 0 );
              b                : in  std_logic_vector( busWidth - 1 downto 0 );
              valid_in         : in  std_logic;
              valid_out        : out std_logic;
              control          : out std_logic_vector( busWidth downto 0 )
            );        

  end component integral;

  signal extended_dataa       : std_logic_vector( extendedBusWidth - 1 downto 0 );
  signal extended_reference   : std_logic_vector( extendedBusWidth - 1 downto 0 );
  signal internal_difference  : std_logic_vector( extendedBusWidth - 1 downto 0 );
  signal zero_signal          : std_logic;

  -- Synchronize the outputs to decrease the delay path
  --
  signal sync_difference      : std_logic_vector( busWidth downto 0 );

  signal valid_in_delayed1    : std_logic;

begin

  -- Sign extend the data
  --
  extended_dataa( busWidth - 1 downto 0 )     <= data_a;
  extended_dataa( busWidth )                  <= '0';
  extended_reference( busWidth - 1 downto 0 ) <= reference;
  extended_reference( busWidth )              <= '0';

  -- Create an active low signal
  --
  zero_signal <= '0';

  -- Subtract the data
  --
  diff : lpm_add_sub generic map ( lpm_width          => extendedBusWidth,
                                   lpm_representation => "SIGNED",
                                   lpm_pipeline       => 1
                                 )
                     port    map (
                                   dataa              => extended_reference,
                                   datab              => extended_dataa,
                                   aclr               => reset,
                                   clock              => clock,
                                   add_sub            => zero_signal,
                                   clken              => valid_in,
                                   result             => internal_difference
                                 );

  -- Flop the valid_in signal so it will enable the next level of adder
  -- and output flops
  --
  delay1 : synchronizor generic map ( numberOfLevels => 1 )
                        port    map ( 
                                      clock          => clock,
                                      reset          => reset,
                                      input          => valid_in,
                                      output         => valid_in_delayed1
                                    );

  -- Register the data for output
  --
  flop_diff : lpm_ff generic map ( lpm_width => extendedBusWidth )
                     port    map (
                                   data      => internal_difference,
                                   clock     => clock,
                                   enable    => valid_in_delayed1,
                                   aclr      => reset,
                                   q         => sync_difference
                                 );

  -- Integrate
  --
  i : integral generic map (
                             busWidth         => busWidth,
                             extendedBusWidth => extendedBusWidth
                           )
               port    map (
                             clock            => clock,
                             reset            => reset,
                             a                => data_a,
                             b                => data_b,
                             valid_in         => valid_in,
                             valid_out        => valid_out,
                             control          => integration
                           );
      
  -- Wire difference and delta output
  --
  difference  <= sync_difference( busWidth - 1 downto 0 );

end massage;
