-- Mazebot Project
-- EE552 Fall 2000
--
-- Authors:
-- Steve Dillen 225760
--
-- October 9, 2000
--
-- frequency_divider.vhd
-- This file implements a frequency divider circuit that can be used as
-- an enable signal to implement an effective slower clock, without effecting
-- the system clock.  The input divisor will actually product divisor + 1
-- frequency clock.
--

library ieee;
use ieee.std_logic_1164.all;

library work;
use work.config.all;

entity frequency_divider is

  generic ( busWidth : positive := 4 );

  port    ( clock     : in  std_logic;
            reset     : in  std_logic;
            divisor   : in  std_logic_vector( busWidth - 1 downto 0 );
            frequency : out std_logic
          );

end frequency_divider;

architecture RTL of frequency_divider is

  signal internal_count     : std_logic_vector( busWidth - 1 downto 0 );
  signal internal_compare   : std_logic_vector( busWidth - 1 downto 0 );
  signal internal_frequency : std_logic;
  signal one_signal         : std_logic;

begin

  one_signal <= '1';

  counter    : lpm_counter generic map ( lpm_width       => busWidth )
                           port    map (
                                         clock           => clock,
                                         sclr            => internal_frequency,
                                         q               => internal_count
                                       );

  sync_count : synchronizor generic map ( numberOfLevels => 1 )
                            port    map (
                                          clock          => clock,
                                          reset          => reset,
                                          input          => internal_frequency,
                                          output         => frequency
                                        );

  compare    : lpm_compare generic map ( 
                                         lpm_width       => busWidth,
                                         lpm_pipeline    => 1
                                       )

                           port    map ( 
                                         dataa           => internal_count,
                                         datab           => divisor,
                                         clock           => clock,
                                         agb             => internal_frequency 
                                       );

end RTL;

