-- Mazebot Project
-- EE552 Fall 2000
--
-- Authors:
-- Steve Dillen 225760
-- Farrah Rashid 354698
--
-- November 13, 2000
--
-- duty_splitter.vhd
-- This module generates the length of time the pwm should be on,
-- and the length of time it should be off.
--

-- Include ieee std types
--
library ieee;
use ieee.std_logic_1164.all;

-- Include Mazebot configuration
--
library work;
use work.config.all;

entity duty_splitter is

  generic ( busWidth   : positive := 2 );

  port    ( clock      : in  std_logic;
            reset      : in  std_logic;
            duty_cycle : in  std_logic_vector( busWidth - 1 downto 0 );
            on_duty    : out std_logic_vector( busWidth - 1 downto 0 );
            off_duty   : out std_logic_vector( busWidth - 1 downto 0 )
          );

end duty_splitter;

architecture RTL of duty_splitter is

  signal maximum_unsigned : std_logic_vector( busWidth - 1 downto 0 );
  signal subtract         : std_logic;

begin

  -- Set-up the constant signals
  --
  maximum_unsigned <= ( others => '1' );
  subtract         <= '0';

  calculate_off_duty : lpm_add_sub generic map ( 
                                                 lpm_width          => busWidth,
                                                 lpm_representation => "UNSIGNED",
                                                 lpm_pipeline       => 1
                                               )
                                   port    map (
                                                 dataa              => maximum_unsigned,
                                                 datab              => duty_cycle,
                                                 aclr               => reset,
                                                 clock              => clock,
                                                 add_sub            => subtract,
                                                 result             => off_duty
                                               );

  flop_on_duty : lpm_ff generic map ( lpm_width => busWidth )
                        port    map (
                                      data      => duty_cycle,
                                      clock     => clock,
                                      sclr      => reset,
                                      q         => on_duty
                                    );

end RTL;
