-- Mazebot Project
-- EE552 Fall 2000
--
-- Authors:
-- Steve Dillen 225760
--
-- November 13, 2000
--
-- duty_counter.vhd
-- This module generates the counter that switches the duty from on/off based
-- on the duty time.
--

-- Include ieee std types
--
library ieee;
use ieee.std_logic_1164.all;

-- Include Mazebot configuration
--
library work;
use work.config.all;

entity duty_counter is

  generic ( busWidth   : positive := 2 );

  port    ( clock      : in  std_logic;
            reset      : in  std_logic;
            duty_cycle : in  std_logic_vector( busWidth - 1 downto 0 );
            match      : out std_logic
          );

end duty_counter;

architecture RTL of duty_counter is

  signal internal_count         : std_logic_vector( busWidth - 1 downto 0 );
  signal internal_match         : std_logic;
  signal internal_clear         : std_logic;

begin

  count_cycles : lpm_counter generic map ( lpm_width => busWidth )
                             port    map (
                                           clock     => clock,
                                           aclr      => internal_clear,
                                           q         => internal_count
                                         );

  compare_duty : lpm_compare generic map ( 
                                           lpm_width => busWidth,
                                           lpm_pipeline => 1
                                         )
                             port    map (
                                           dataa        => internal_count, 
                                           datab        => duty_cycle,
                                           aclr         => reset,
                                           clock        => clock,
                                           agb          => internal_match
                                         );

  internal_clear <= internal_match or reset;
  match          <= internal_match;

end RTL;
