--
-- Display module
--

library ieee;
use ieee.std_logic_1164.all;

library work;
use work.config.all;

entity display is

  port ( clock  : in  std_logic;
         reset  : in  std_logic;
         valid  : in  std_logic;
         number : in  std_logic_vector( 3 downto 0 );
         output : out std_logic_vector( 7 downto 0 )
       );

end display;

architecture RTL of display is
begin

  show : process

  begin

    wait until rising_edge( clock );

    if reset = '1' then

      output <= ( others => '1' );

    else

      if valid = '1' then

        case number is

          when "0000" =>

            output <= "00000011";

          when "0001" =>

            output <= "10011111";

          when "0010" =>

            output <= "00100101";

          when "0011" =>

            output <= "00001101";

          when "0100" =>

            output <= "10011001";

          when "0101" =>

            output <= "01001001";

          when "0110" =>

            output <= "01000001";

          when "0111" =>

            output <= "00011111";

          when "1000" =>

            output <= "00000001";

          when "1001" =>

            output <= "00001001";

          when "1010" =>

            output <= "00010000";

          when "1011" =>

            output <= "00000000";

          when "1100" =>

            output <= "01100010";

          when "1101" =>

            output <= "00000010";

          when "1110" =>

            output <= "01100000";

          when "1111" =>

            output <= "01110000";

          when others =>

            output <= ( others => '1' );

        end case;

      end if;

    end if;

  end process show;

end RTL;
