-- Mazebot counter
--

library ieee;
use ieee.std_logic_1164.all;
use ieee.std_logic_arith.all;
use ieee.std_logic_unsigned.all;

entity controlbot_counter is

  generic ( busWidth : positive := 2 );

  port    ( clock    : in  std_logic;
            reset    : in  std_logic;
            enable   : in  std_logic;
            count    : out std_logic_vector( busWidth - 1 downto 0 )
          );

end entity controlbot_counter;

architecture RTL of controlbot_counter is

  signal internal_count : std_logic_vector( busWidth - 1 downto 0 );

begin

  count    <= internal_count( busWidth - 1 downto 0 );

  counter : process
  begin

    wait until rising_edge( clock );

    if reset = '1' then

      internal_count <= ( others => '0' );

    else

      if enable = '1' then

        internal_count <= internal_count( busWidth - 1 downto 0 ) + '1';

      end if;

    end if;

  end process counter;

end RTL;
