-- *******************************************************************
-- 
-- Owner:	Xilinx Inc.
-- File:  	sirendec.vhd
--
-- Purpose: 	Main IrDA logic module. Hewlett Packard
--		IR 3/16 Encoder/Decoder (HSDL-7000 Verilog Model).
--		This Verilog source code was generated from
--		the original schematic version designed by
--		Parallax Reseach.
--
-- Created:	VHDL code generated by Visual HDL 8-15-01
--  
-- *******************************************************************


library ieee;
use ieee.STD_LOGIC_1164.all;
use ieee.STD_LOGIC_ARITH.all;
use ieee.STD_LOGIC_MISC.all;
use ieee.STD_LOGIC_UNSIGNED.all;
 
use work.pkg_util.all; 
 
entity sirendec is
  port (
        clk16x 	: in STD_LOGIC;
        irrxd 	: in STD_LOGIC;
        nrcven 	: in STD_LOGIC;
        rxd 	: out STD_LOGIC;
        txd 	: in STD_LOGIC;
        irtxd 	: out STD_LOGIC
        );
end sirendec;


architecture behavior of sirendec is
 
 
component jk_ff
port (
	    clk 	: in STD_LOGIC;
	    J 		: in STD_LOGIC;
	    K 		: in STD_LOGIC;
	    CLR 	: in STD_LOGIC;
	    jkout 	: out STD_LOGIC
            );
end component;


signal q0 		: STD_LOGIC;
signal q1 		: STD_LOGIC;
signal q2 		: STD_LOGIC;
signal q3 		: STD_LOGIC;
signal trigctl 		: STD_LOGIC;
signal count8reset 	: STD_LOGIC;
signal one_more 	: STD_LOGIC;
signal clear_ff	 	: STD_LOGIC;
signal restrigff 	: STD_LOGIC;
signal reset_count 	: STD_LOGIC;
signal din_q1 		: STD_LOGIC;
signal din_q2 		: STD_LOGIC;
signal din_q3 		: STD_LOGIC;
signal judge_1 		: STD_LOGIC;
signal judge_2 		: STD_LOGIC;
signal count4bit 	: STD_LOGIC_VECTOR(3 downto 0 );
signal dec8clkcount 	: STD_LOGIC;
signal dec10cycclk 	: STD_LOGIC;

signal jk_clk, jk_jinput, jk_clr : STD_LOGIC;


begin
 
  rxd <= not(clear_ff);
  restrigff <= nrcven and count8reset;
  reset_count <= not((not(one_more)) or (not(trigctl)));
  din_q1 <= not(reset_count or (not((q0 xor q1))));
  din_q2 <= not(reset_count or (not((q2 xor ((q0 and q1))))));
  din_q3 <= not(reset_count or (not((((q0 and q1 and q2)) xor q3))));
  judge_1 <= not(q0 or q1 or q2 or q3);
  judge_2 <= not((not(q0)) and (not(q1)) and (not(q2)) and q3);
  
  dec8clkcount <= (not(count4bit(0))) or (not(count4bit(1))) or 
  		(not(count4bit(2))) or count4bit(3);
  		
  dec10cycclk <= count4bit(0) or (not(count4bit(1))) or count4bit(2) or 
  		(not(count4bit(3)));
  		
  		
  process (irrxd, restrigff) 
  begin
    	if not((restrigff) = '1' ) then
      		trigctl <= '0';
    	elsif (irrxd'event and irrxd = '0' ) then
      		trigctl <= '1';
    	end if ;
  
  end process ;
 
 
  process (clk16x, clear_ff) 
  begin
    	if not((clear_ff) = '1' ) then
      		q0 <= '0';
   	 elsif (clk16x'event and clk16x = '0' ) then
      		q0 <= (reset_count or (not(q0)));
    	end if ;
    	
  end process ;
 
 
  process (clk16x, clear_ff)
  begin
    	if not((clear_ff) = '1' ) then
      		q1 <= '0';
    	elsif (clk16x'event and clk16x = '0' ) then
      		q1 <= din_q1;
    	end if ;
    	
  end process ;
 
 
  process (clk16x, clear_ff) 
  begin
    	if not((clear_ff) = '1' ) then
      		q2 <= '0';
    	elsif (clk16x'event and clk16x = '0' ) then
      		q2 <= din_q2;
    	end if ;
    	
  end process ;
 
 
  process (clk16x, clear_ff) 
  begin
    	if not((clear_ff) = '1' ) then
      		q3 <= '0';
   	elsif (clk16x'event and clk16x = '0' ) then
      		q3 <= din_q3;
    	end if ;
    	
  end process ;
 
 
  process (clk16x, nrcven) 
  begin
    	if not((nrcven) = '1' ) then
      		count8reset <= '0';
    	elsif (clk16x'event and clk16x = '1' ) then
      		count8reset <= judge_2;
    	end if ;
  end process ;
 
 
  process (clk16x, nrcven)
  begin
    	if not((nrcven) = '1' ) then
     		clear_ff <= '0';
    	elsif (clk16x'event and clk16x = '1' ) then
      		clear_ff <= not(judge_1 and (not(trigctl)));
    	end if ;
    	
  end process ;
 
 
  process (clk16x, nrcven) 
  begin
    	if not((nrcven) = '1' ) then
      		one_more <= '0';
    	elsif (clk16x'event and clk16x = '0' ) then
      		one_more <= q3;
   	end if ;
  
  end process ;
 
 
  process (clk16x, txd) 
  begin
    	if (txd) = '1'  then
      		count4bit <= "0000";
    	elsif (clk16x'event and clk16x = '0' ) then
      		count4bit <= ext(ext(count4bit,32) + 1,abs(3-0)+1);
    	end if ;
    	
  end process ;
 
 
	jk_clk <= not(clk16x);
	jk_jinput <= not(dec8clkcount);
	jk_clr <= not(txd);
 
  	visual_0_jk_ff: jk_ff
    	port map (
              clk => jk_clk,
              J => jk_jinput,
              K => dec10cycclk,
              CLR => jk_clr,
              jkout => irtxd);
 
end ;


