library ieee;
use ieee.std_logic_1164.all;

package pkg_util is

function equal ( arg1, arg2 : std_logic_vector) return std_logic;
function or_logic ( arg1, arg2 : std_logic) return std_logic;
function and_logic ( arg1, arg2 : std_logic) return std_logic;
function not_logic ( arg : std_logic) return std_logic;
function conv_std_logic ( arg : boolean ) return std_logic;

end pkg_util;

package body pkg_util is

------------------------------------------------------------------------

-- Function for "==" translation
function equal ( arg1, arg2 : std_logic_vector) return std_logic
is
begin
  if Is_X ( arg1 ) or Is_X ( arg2 )
  then
    return 'X';
  elsif ( arg1 = arg2 )
  then
    return '1';
  else
    return '0';
  end if;
end equal;

------------------------------------------------------------------------

-- Function for "||" translation
function or_logic ( arg1, arg2 : std_logic) return std_logic
is
begin
  if Is_X ( arg1) or Is_X ( arg2)
  then
    return 'X';
  elsif (  arg1 = '1' or arg2 = '1' )
  then
    return '1';
  else
    return '0';
  end if;
end or_logic;

------------------------------------------------------------------------

-- Function for "&&" translation
function and_logic ( arg1, arg2 : std_logic) return std_logic
is
begin
  if Is_X ( arg1) or Is_X ( arg2)
  then
    return 'X';
  elsif (  arg1 = '1' and arg2 = '1' )
  then
    return '1';
  else
    return '0';
  end if;
end and_logic;

------------------------------------------------------------------------

-- Function for "not" translation
function not_logic ( arg : std_logic) return std_logic
is
begin
  case (arg) is
    when 'X' | 'Z' => return 'X';
    when '1' => return '0';
    when others => return '1'; 
  end case;
end not_logic;

------------------------------------------------------------------------

-- Function for conversion to std_logic
function conv_std_logic ( arg : boolean ) return std_logic is
begin
  if arg
  then
    return '1';
  else
    return '0';
  end if;
end;

------------------------------------------------------------------------

end pkg_util;
