library ieee;
use ieee.std_logic_1164.all;
use ieee.std_logic_arith.all;
use ieee.std_logic_unsigned.all;

entity niosII_microc_lab1 is
        port
        (
		  
						 -- LCD ports
                LCD_ON  :  out std_logic;
                LCD_BLON :      out std_logic;
                LCD_EN  :       out std_logic;
                LCD_RS  :       out std_logic;
                LCD_RW  :       out std_logic;
                LCD_DATA        :       inout   std_logic_vector (7 downto 0);
					 
					 -- LEDS
					 LEDG    : out std_logic_vector(7 downto 0);
					 LEDR 	:	out std_logic_vector(17 downto 0);
					 
					-- SRAM ports
					SRAM_ADDR : out std_logic_vector ( 17 downto 0);
					SRAM_DQ : inout std_logic_vector ( 15 downto 0);
					SRAM_WE_N : out std_logic;
					SRAM_UB_N: out std_logic;
					SRAM_LB_N : out std_logic;
					SRAM_CE_N: out std_logic;
					SRAM_OE_N : out std_logic;
					 
					 -- DRAM ports
					 DRAM_CLK, DRAM_CKE : OUT STD_LOGIC;
					 DRAM_ADDR : OUT STD_LOGIC_VECTOR(11 DOWNTO 0);
					DRAM_BA_1, DRAM_BA_0 : BUFFER STD_LOGIC;
                DRAM_CS_N, DRAM_CAS_N, DRAM_RAS_N, DRAM_WE_N : OUT STD_LOGIC;
                DRAM_DQ : INOUT STD_LOGIC_VECTOR(15 DOWNTO 0);
                DRAM_UDQM, DRAM_LDQM : BUFFER STD_LOGIC ;

                -- CLOCK port
                CLOCK_50        :       in  std_logic;
					 
					 -- Switch			
					 SW					:			in std_logic_vector(3 downto 0);
					 
                -- RESET key
                KEY             :       in  std_logic_vector(3 downto 0);
					 GPIO_0		: out std_logic_vector(10 downto 0);
					 IRDA_RXD 	: in std_logic
                );
end niosII_microc_lab1;



architecture structure of niosII_microc_lab1 is


component irda_xlinx is
		port(
			reset	: in	std_logic;
			readdata : out	std_logic_vector(31 downto 0);
			piodata : out	std_logic_vector(63 downto 0);
			datardy: out std_logic;
			irq	: out std_logic;
			irrxd : in 	std_logic;
			perror:	out	std_logic;
			ferror: out 	std_logic;
			overrun: out	std_logic;
			clkin : in 	std_logic
		);
end component;


signal BA : STD_LOGIC_VECTOR (1 downto 0);
signal DQM : STD_LOGIC_VECTOR (1 downto 0);
--signal pll_c0:STD_LOGIC;
signal pll_c1:STD_LOGIC;
signal pll_locked:STD_LOGIC;
signal pll_phase: STD_LOGIC;

signal irda_reset : std_logic;
signal irda_readdata : std_logic_vector( 31 downto 0 );
signal irda_piodata : std_logic_vector( 63 downto 0 );
signal irda_irrxd : std_logic;
signal irda_irq : std_logic;
signal irda_return_data: std_logic;

signal nios_irda_data_irq : std_logic;
signal nios_irda_data : std_logic_vector ( 31 downto 0 );
signal nios_reset_n : std_logic ;

signal LED : std_logic_Vector( 25 downto 0 );

signal myLCD : STD_LOGIC_VECTOR (10 downto 0);

begin
  -- I have no idea why the SOPC-created IP does not turn the LCD on at all.
  -- I've explicitly turned it on with the next loc.      Note that LCD_ON is the
  -- VCC power line not the programmaticly controlled version that is bit banged.

  LCD_ON <= '1';
  
  -- ################################# IRDA code starts here ##############################
  irda_irrxd <= IRDA_RXD;
  nios_reset_n <= KEY(0);

  
  -- irda reset
  process ( nios_reset_n )
  begin
		case nios_reset_n is
			when '0' => irda_reset <= '1';
			when '1' =>	irda_reset <= SW(0);
			when others => irda_reset <= '0';
		end case;
  end process;
  

  
     irda_0: irda_xlinx port map (
			reset			=> irda_reset,
			readdata 	=> irda_readdata,
			piodata 		=> irda_piodata,
			datardy		=> irda_return_data,
			irq			=> irda_irq,
			irrxd 		=> irda_irrxd,
			perror		=> LED(3),
			ferror		=> LED(1),
			overrun		=> LED(2),
			clkin 		=> CLOCK_50
	);
  
	
	-- ############################## IRDA code ends here ################################
	
	
	DRAM_BA_1 <= BA(1);
  DRAM_BA_0 <= BA(0);
  DRAM_UDQM <= DQM(1);
  DRAM_LDQM <= DQM(0);
             
end structure;
		  

		  
