library ieee;
use ieee.STD_LOGIC_1164.all;
use ieee.STD_LOGIC_ARITH.all;
use ieee.STD_LOGIC_MISC.all;
use ieee.STD_LOGIC_UNSIGNED.all;


entity irda_xlinx is
	port(
		reset	: in	std_logic;
		readdata : out	std_logic_vector(31 downto 0);
		piodata : out	std_logic_vector(63 downto 0);
		datardy: out std_logic;
		irq	: out std_logic;
		irrxd : in 	std_logic;
		perror:	out	std_logic;
		ferror: out 	std_logic;
		overrun: out	std_logic;
		clkin : in 	std_logic
		);
end entity irda_xlinx;

architecture top of irda_xlinx is



component sirendec
      port (
        clk16x 	: in STD_LOGIC;
        irrxd 	: in STD_LOGIC;
        nrcven : in std_logic;
        rxd 	: out STD_LOGIC;
        txd 	: in STD_LOGIC;
        irtxd 	: out STD_LOGIC
        );
  end component;
  
  signal sir_rxd : std_logic;
  signal sir_rxd_n : std_logic;
  signal sir_irtxd : std_logic;
  
--  component irda_component
--    port (
--      coe_irda_sig_export : in STD_LOGIC; 		-- coarse irda signal
 --     x16clk : in STD_LOGIC;		-- clk 16x faster than signal (70.3125 us period)
--      data : out STD_LOGIC_VECTOR(31 DOWNTO 0);		-- 12-bit command code
--      irq : out STD_LOGIC			-- signals that data is ready to be read 
--		);
--  end component;

component irda_com is
  port (
        mclkx16 	: in STD_LOGIC;
        read 		: in STD_LOGIC;
        sin 		: in STD_LOGIC;
        reset 		: in STD_LOGIC;
        rxrdy 		: out STD_LOGIC;
        parity_error 	: out STD_LOGIC;
        framing_error 	: out STD_LOGIC;
        overrun 	: out STD_LOGIC;
        rxdata 		: out STD_LOGIC_VECTOR(63 downto 0 )
        );
    
end component;

  signal irda_read_n : std_logic;	
	signal dataready : std_logic;
	--signal perror : std_logic;
	--signal ferror : std_logic;
	--signal overrun : std_logic; 
	signal data : std_logic_vector(63 downto 0);
  
  component clock_scaler
    port (
      clkin        : in std_logic                     := '0';         
      clockout        : out std_logic                 := '0';     
      write_n      : in std_logic                     := '0';        
      new_scalefactor : in std_logic_vector(31 downto 0) := (others => '0') 
	);
  end component;
  
  
  signal write_clk_scale : std_logic := '1';
  signal clk_608 	: std_logic := '0';
  signal clk_14	: std_logic := '0';
  signal scale_608 : std_logic_vector(31 downto 0) := x"00000029";
  signal scale_14 : std_logic_vector(31 downto 0) := x"0000036e";
  
  signal reset_n : std_logic := '0';
  signal intrq : std_logic := '0';
  
  signal return_data : std_logic;  -- signals return data on rising edge
  
begin  -- top 
  
  datardy <= return_data;
  irq <= intrq;
	
	
	process (irda_read_n, reset )
	begin
		if (reset = '1') then
			return_data <= '1';
		elsif rising_edge( irda_read_n ) then
			return_data <= not( return_data );
		end if;			
	end process;
	
	
	process(return_data, reset)
	begin
		if (reset = '1') or ( return_data = '0' ) then
			readdata <= x"00000000";
			piodata <= x"0000000000000000";		
		elsif ( return_data = '1') then
			readdata <= data( 31 downto 0 );
			piodata <= data;
		end if;
	end process;
	

  irda_read_n <= not ( intrq );
  
  reset_n <= not(reset);
  sir_rxd_n <= not ( sir_rxd );

  process( clkin, reset )
  begin
		if (reset = '1') then
			write_clk_scale <= '0';
			scale_14 <= x"0000036e";
			scale_608 <= x"00000029";
		elsif rising_edge(clkin) then
			write_clk_scale <= '1';
		end if;
  end process;
  
  process( dataready, clk_14 )
  variable pulsed : std_logic := '0';
  begin
	if rising_edge( clk_14 ) and (dataready  = '1' ) and (pulsed = '0') then
		intrq <= '1';
		pulsed := '1';
	elsif rising_edge(clk_14) and (pulsed = '1') and (dataready = '1') then
		intrq <= '0';
	elsif rising_edge(clk_14) and (pulsed = '1') and (dataready = '0') then
		pulsed := '0';
	end if;	
	
  end process;
  
  
  sirendec_0: sirendec
   port map (
        clk16x => clk_608,
        irrxd 	=> irrxd,
		  nrcven => reset_n,
        rxd 	=> sir_rxd,
        txd 	=> '0',
		  irtxd  => sir_irtxd
        );
  
  clk_scaler_0: clock_scaler
    port map (
      clkin           => clkin,
      clockout        => clk_608,
      write_n         => write_clk_scale,
      new_scalefactor => scale_608);

  clk_scaler_1: clock_scaler
    port map (
      clkin           => clkin,
      clockout        => clk_14,
      write_n         => write_clk_scale,
      new_scalefactor => scale_14);
      
  irda_po: irda_com
    port map (
        mclkx16 	     => clk_14,
        read 		       => irda_read_n,
        sin 		        => sir_rxd,
        reset 	       => reset,
        rxrdy 		      => dataready,
        parity_error 	=> perror,
        framing_error => ferror,
        overrun 	     => overrun,
        rxdata 		     => data
        );
        
		
--  irda_po: irda_component
  --  port map (
    --  coe_irda_sig_export => sir_rxd_n,
      --x16clk              => clk_14,
      --data           	  => readdata,
      --irq                 => dataready);

end architecture;
