library ieee;
use ieee.STD_LOGIC_1164.all;
use ieee.STD_LOGIC_ARITH.all;
use ieee.STD_LOGIC_MISC.all;
use ieee.STD_LOGIC_UNSIGNED.all;


entity irda_tb is
  
end irda_tb;

architecture behavioural of irda_tb is
  
  component irda_xlinx is
    port(
      read_n  : in std_logic;
      reset	  : in	std_logic;
      readdata: out	std_logic_vector(63 downto 0);
	    irq	    : out std_logic;
	    irrxd   : in 	std_logic;
	    perror  :	out	std_logic;
      ferror  : out 	std_logic;
      overrun : out	std_logic;
	    clkin   : in 	std_logic
  );
  end component;
  

  
  signal  reset     : std_logic;
  signal  readdata  : std_logic_vector(63 downto 0);
  signal  irq       : std_logic;
  signal  irrxd     : std_logic;
  signal  clkin     : std_logic;
  signal  read_n    : std_logic;
  
  signal  nec       : std_logic;

begin
  
read_n <= not( irq );

process
begin
  for i in 0 to 5 loop
    wait for 10 ms;
  reset <= '1';
  wait for 10 ms;
  reset <= '0';
  wait for 1000 ms; 
  end loop;
end process;
  

process 
begin 
  for i in 0 to 4926 loop
  irrxd <=  not ( nec );
  wait for 2.6 us;
  irrxd <= '1';
  wait for 23.4 us;
  end loop;
end process;  

process
begin
  clkin <= '1';
  wait for 20 ns;
  clkin <= '0';
  wait for 20 ns;
end process;

process
begin
  -- 40 + 68.0625 = 108.0625 ms
  for i in 0 to 3 loop
    
    -- starting sequence
    nec <= '0'; wait for 40 ms;
    nec <= '1'; wait for 9 ms;
    nec <= '0'; wait for 4.5 ms;
  
  
    -- address
    nec <= '1'; wait for 562.5 us;    -- 0
    nec <= '0'; wait for 562.5 us;
  
    nec <= '1'; wait for 562.5 us;    -- 0
    nec <= '0'; wait for 562.5 us;
  
    nec <= '1'; wait for 562.5 us;    -- 0
    nec <= '0'; wait for 562.5 us;
  
    nec <= '1'; wait for 562.5 us;    -- 0
    nec <= '0'; wait for 562.5 us;
  
    nec <= '1'; wait for 562.5 us;    -- 0
    nec <= '0'; wait for 562.5 us;
  
    nec <= '1'; wait for 562.5 us;    -- 0
    nec <= '0'; wait for 562.5 us;
  
    nec <= '1'; wait for 562.5 us;    -- 0
    nec <= '0'; wait for 562.5 us;

    nec <= '1'; wait for 562.5 us;    -- 0
    nec <= '0'; wait for 562.5 us;
  
  
    -- inverse address
    nec <= '1'; wait for 562.5 us;    -- 1
    nec <= '0'; wait for 1687.5 us;
  
    nec <= '1'; wait for 562.5 us;    -- 1
    nec <= '0'; wait for 1687.5 us;
  
    nec <= '1'; wait for 562.5 us;    -- 1
    nec <= '0'; wait for 1687.5 us;
  
    nec <= '1'; wait for 562.5 us;    -- 1
    nec <= '0'; wait for 1687.5 us;
  
    nec <= '1'; wait for 562.5 us;    -- 1
    nec <= '0'; wait for 1687.5 us;
  
    nec <= '1'; wait for 562.5 us;    -- 1
    nec <= '0'; wait for 1687.5 us;
  
    nec <= '1'; wait for 562.5 us;    -- 1
    nec <= '0'; wait for 1687.5 us;
  
    nec <= '1'; wait for 562.5 us;    -- 1
    nec <= '0'; wait for 1687.5 us;
  
    --data begin
    nec <= '1'; wait for 562.5 us;    -- 0
    nec <= '0'; wait for 562.5 us;
  
    nec <= '1'; wait for 562.5 us;    -- 1
    nec <= '0'; wait for 1687.5 us;
  
    nec <= '1'; wait for 562.5 us;    -- 0
    nec <= '0'; wait for 562.5 us;
  
    nec <= '1'; wait for 562.5 us;    -- 1
    nec <= '0'; wait for 1687.5 us;
  
    nec <= '1'; wait for 562.5 us;    -- 0
    nec <= '0'; wait for 562.5 us;
  
    nec <= '1'; wait for 562.5 us;    -- 1
    nec <= '0'; wait for 1687.5 us;
  
    nec <= '1'; wait for 562.5 us;    -- 0
    nec <= '0'; wait for 562.5 us;
  
    nec <= '1'; wait for 562.5 us;    -- 1
    nec <= '0'; wait for 1687.5 us;
  
    -- inverse data
    nec <= '1'; wait for 562.5 us;    -- 1
    nec <= '0'; wait for 1687.5 us;
  
    nec <= '1'; wait for 562.5 us;    -- 0
    nec <= '0'; wait for 562.5 us;
  
    nec <= '1'; wait for 562.5 us;    -- 1
    nec <= '0'; wait for 1687.5 us;
  
    nec <= '1'; wait for 562.5 us;    -- 0
    nec <= '0'; wait for 562.5 us;
  
    nec <= '1'; wait for 562.5 us;    -- 1
    nec <= '0'; wait for 1687.5 us;
  
    nec <= '1'; wait for 562.5 us;    -- 0
    nec <= '0'; wait for 562.5 us;
  
    nec <= '1'; wait for 562.5 us;    -- 1
    nec <= '0'; wait for 1687.5 us;
  
    nec <= '1'; wait for 562.5 us;    -- 0
    nec <= '0'; wait for 562.5 us;
    
    --  stop bit
    nec <= '1'; wait for 562.5 us;    -- 1
  
  end loop;
  
  -- write three more pulses but with different data
  for i in 0 to 3 loop
      
      -- starting sequence
      nec <= '0'; wait for 40 ms;
      nec <= '1'; wait for 9 ms;
      nec <= '0'; wait for 4.5 ms;
    
    
      -- address
      nec <= '1'; wait for 562.5 us;    -- 0
      nec <= '0'; wait for 562.5 us;
    
      nec <= '1'; wait for 562.5 us;    -- 0
      nec <= '0'; wait for 562.5 us;
    
      nec <= '1'; wait for 562.5 us;    -- 0
      nec <= '0'; wait for 562.5 us;
    
      nec <= '1'; wait for 562.5 us;    -- 0
      nec <= '0'; wait for 562.5 us;
    
      nec <= '1'; wait for 562.5 us;    -- 0
      nec <= '0'; wait for 562.5 us;
    
      nec <= '1'; wait for 562.5 us;    -- 0
      nec <= '0'; wait for 562.5 us;
    
      nec <= '1'; wait for 562.5 us;    -- 0
      nec <= '0'; wait for 562.5 us;
  
      nec <= '1'; wait for 562.5 us;    -- 0
      nec <= '0'; wait for 562.5 us;
    
    
      -- inverse address
      nec <= '1'; wait for 562.5 us;    -- 1
      nec <= '0'; wait for 1687.5 us;
    
      nec <= '1'; wait for 562.5 us;    -- 1
      nec <= '0'; wait for 1687.5 us;
    
      nec <= '1'; wait for 562.5 us;    -- 1
      nec <= '0'; wait for 1687.5 us;
    
      nec <= '1'; wait for 562.5 us;    -- 1
      nec <= '0'; wait for 1687.5 us;
    
      nec <= '1'; wait for 562.5 us;    -- 1
      nec <= '0'; wait for 1687.5 us;
    
      nec <= '1'; wait for 562.5 us;    -- 1
      nec <= '0'; wait for 1687.5 us;
    
      nec <= '1'; wait for 562.5 us;    -- 1
      nec <= '0'; wait for 1687.5 us;
    
      nec <= '1'; wait for 562.5 us;    -- 1
      nec <= '0'; wait for 1687.5 us;
    
      --data begin
      nec <= '1'; wait for 562.5 us;    -- 0
      nec <= '0'; wait for 562.5 us;
    
      nec <= '1'; wait for 562.5 us;    -- 0
      nec <= '0'; wait for 562.5 us;
    
      nec <= '1'; wait for 562.5 us;    -- 0
      nec <= '0'; wait for 562.5 us;
      
      nec <= '1'; wait for 562.5 us;    -- 0
      nec <= '0'; wait for 562.5 us;
          
      nec <= '1'; wait for 562.5 us;    -- 1
      nec <= '0'; wait for 1687.5 us;
    
      nec <= '1'; wait for 562.5 us;    -- 1
      nec <= '0'; wait for 1687.5 us;

      nec <= '1'; wait for 562.5 us;    -- 1
      nec <= '0'; wait for 1687.5 us;
    
      nec <= '1'; wait for 562.5 us;    -- 1
      nec <= '0'; wait for 1687.5 us;
    
      -- inverse data
      nec <= '1'; wait for 562.5 us;    -- 1
      nec <= '0'; wait for 1687.5 us;
    
      nec <= '1'; wait for 562.5 us;    -- 1
      nec <= '0'; wait for 1687.5 us;
    
      nec <= '1'; wait for 562.5 us;    -- 1
      nec <= '0'; wait for 1687.5 us;
          
      nec <= '1'; wait for 562.5 us;    -- 1
      nec <= '0'; wait for 1687.5 us;
    
      nec <= '1'; wait for 562.5 us;    -- 0
      nec <= '0'; wait for 562.5 us;
      
      nec <= '1'; wait for 562.5 us;    -- 0
      nec <= '0'; wait for 562.5 us;
      
      nec <= '1'; wait for 562.5 us;    -- 0
      nec <= '0'; wait for 562.5 us;
        
      nec <= '1'; wait for 562.5 us;    -- 0
      nec <= '0'; wait for 562.5 us;
      
      --  stop bit
      nec <= '1'; wait for 562.5 us;    -- 1
    
    end loop;

end process;

irda_0: irda_xlinx
  port map (
    read_n => read_n,
    reset => reset,
    readdata => readdata,
    irq => irq,
    irrxd => irrxd,
    clkin => clkin
  );
  
  
end behavioural;


