library ieee;
use ieee.STD_LOGIC_1164.all;
use ieee.STD_LOGIC_ARITH.all;
use ieee.STD_LOGIC_MISC.all;
use ieee.STD_LOGIC_UNSIGNED.all;

entity cyclone is
	port(
		IRDA_RXD : in 	std_logic;
		CLOCK_50 : in 	std_logic;
		LEDR		: out	std_logic_vector( 17 downto 0);
		LEDG		: out std_logic_vector( 7 downto 0);
		SW			: in std_logic_vector( 17 downto 0 );
		GPIO_0	: out std_logic_vector( 3 downto 0 )
		);
end cyclone;

architecture wireup of cyclone is

component irda_xlinx is
	port(
		read_n	:	in	std_logic;
		reset	: in	std_logic;
		readdata : out	std_logic_vector(31 downto 0);
		piodata	: out	std_logic_vector(63 downto 0);
		datardy	:	out std_logic;
		irq	: out std_logic;
		irrxd : in 	std_logic;
		perror : out	std_logic;
		ferror : out 	std_logic;
		overrun	:	out std_logic;
		clkin : in 	std_logic
		);
end component;

signal reset 	:	std_logic;
signal irq 		:	std_logic; -- no conn
signal rddata	:	std_logic_vector(31 downto 0);
signal readdata: 	std_logic_vector( 63 downto 0 );
signal readdata1: std_logic_vector( 63 downto 0 );
signal dataready: std_logic;
signal read_n 	: 	std_logic;
signal perror	:	std_logic;
signal ferror	:	std_logic;
signal overrun	:	std_logic;


begin

	reset <= SW(0);
	
	read_n <= not ( irq );			
	
	process ( reset, irq )
	
	begin
		if ( reset = '1' ) then
			readdata1 <= x"0000000000000000";
		elsif rising_edge( irq ) then 

			readdata1 <= readdata;
		end if;
	end process;

	irda_0: irda_xlinx 
		port map (
			read_n		=>	read_n,
			reset 		=>	reset,
			datardy 		=>	dataready,
			readdata		=> rddata,
			piodata		=>	readdata,
			irq			=> irq,
			irrxd			=>	IRDA_RXD,
			perror		=> perror,
			ferror		=>	ferror,
			overrun		=>	overrun,
			clkin			=>	CLOCK_50			
		);
		
	LEDR <= readdata1( 25 downto 8 );
	LEDG <= readdata1( 7 downto 0 );
	
	GPIO_0(0) <= irq;
	GPIO_0(1) <= IRDA_RXD;
	GPIO_0(2) <= perror or ferror or overrun;
	GPIO_0(3) <= dataready;
	
	
end wireup;