-- irda_mclkx16.vhd

-- This file was auto-generated as a prototype implementation of a module
-- created in component editor.  It ties off all outputs to ground and
-- ignores all inputs.  It needs to be edited to make it do something
-- useful.
-- 
-- This file will not be automatically regenerated.  You should check it in
-- to your version control system if you want to keep it.
--      
--      clock scaler:  author Timothy Bauman
--      

library IEEE;
use IEEE.std_logic_1164.all;
use IEEE.numeric_std.all;
use IEEE.STD_LOGIC_ARITH.ALL;
use IEEE.STD_LOGIC_UNSIGNED.ALL;

entity clock_scaler is
	port (
		clkin        : in std_logic                     := '0';             --   clock_sink.clk
		clockout        : out std_logic                     := '0';             -- clock_source.clk
		write_n      : in std_logic                     := '0';             -- avalon_slave.write_n
		new_scalefactor : in std_logic_vector(31 downto 0) := (others => '0')  --      .writedata
	);
end entity clock_scaler;


architecture rtl of clock_scaler is

  signal scalefactor : std_logic_vector (31 downto 0) := "00000000000000000000000000000000";  -- baudrate
  signal clockcount : std_logic_vector (31 downto 0) := "00000000000000000000000000000000";
  signal clkout : std_logic := '0';       -- clockout buffer
begin

  clockout <= clkout;
  
  writing: process(write_n)
  begin
    if falling_edge(write_n) then
      scalefactor <= new_scalefactor;  -- 
	 end if;     
  end process;                                   

  genIrdaClk: process(clkin, write_n, clockcount)
  begin
	
	  if rising_edge(clkin) and (write_n = '0') then
        clockcount <= scalefactor;  -- extra long clock pulse better than super short clock pulse
    elsif rising_edge(clkin) and ( clockcount <= 1 )  then  -- every half period     
      clkout <= not(clkout);     -- toggle clkout
      clockcount <= scalefactor;
    elsif rising_edge(clkin) then
      clockcount <= clockcount - 1;
    end if;
	
  end process;

  
end architecture rtl; -- of irda_mclkx16
