/*********************
FILE NAME: main.c
AUTHOR: Max Marcus
GROUP: Group1
PROJECT: iOS Remote Control Car
COURSE: CMPE 450
SCHOOL: University of Alberta - Faculty of Engineering
DATE: Feb. 27, 2011

DESCRIPTION:
This program can be used to generate pin assignment .csv files for Quartus II.

HOW TO USE THIS PROGRAM:
1. Find a table of pin assignments in the PDF user manual for an Altera FPGA board (we tested it for the DE0 Nano).
2. Copy and paste the table into a text file and then name the text file "raw_pins.txt".
3. Move "raw_pins.txt" into the same folder as "main.c" (if it is not already there).
4. Find the following line at the beginning of the code below: 
	char* outFileName = "DE0_Nano_pin_assignments_NAME.csv";
5. Change the name of the output file to anything you like by modifying the string between the quotations. Just make sure that it ends with the .csv extension.
6. Save main.c (this code file). In a terminal, navigate to the folder that contains "main.c", "makefile", and "raw_pins.txt".
7. Enter the following two commands: "make" and then "./main".
8. The program will create a .csv with the name that you supplied for the output file. You now have your pin assignments which you can import this into Quartus II.
9. Repeat if necessary.

FORMAT OF INPUT FILE:
After following the above instructions, the "raw_pins.txt" file should have the following format that repeats ever 4 lines. Omit the square brackets (they are just to make this easier to read).

[Signal Name]
[FPGA Pin No.]
[Description]
[I/O Standard]

FORMAT OF OUTPUT FILE:
To,Location
[Signal Name],[FPGA Pin No.]
[Signal Name],[FPGA Pin No.]

*********************/

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#define MAX_LEN 127
 
int main(void)
{
    FILE *inFile;
    FILE *outFile;
    char* inFileName = "raw_pins.txt";
    char* outFileName = "DE0_Nano_pin_assignments_NAME.csv";
    
    inFile = fopen(inFileName, "r");
    
    // Checks whether the output file already exists, to avoid unwanted overwriting.
    if(fopen(outFileName, "r") != NULL) 
    {
    	char response = '\0';
    	
    	while((response != 'n') && (response != 'y'))
    	{
    		printf("The file %s already exists. Would you like to replace it? (y/n)\n", outFileName);
    		response = fgetc(stdin);
    		
    		if(response == 'n')
    		{
    			printf("Pins assignment not generated.\n");
    			return 0;
    		} 
    		   		
    		else if(response == 'y')
    			break;
    	}
    }

    outFile = fopen(outFileName, "w");
    
    if(inFile == NULL)
    {
    	printf("Error opening the input file \"raw_pins.txt\".\n");
    	return 0;
    }
    
    if(outFile == NULL)
    {
    	printf("Error opening the output file \"DE0_Nano_pin_assignments_NAME.csv\".\n");
    	return 0;
    }    
    
    // This string is used for temporary storage.
    char* thisLine;
    thisLine = malloc(sizeof(char) * MAX_LEN);
    memset(thisLine, '\0', MAX_LEN);
    
    // This string will be printed to the output file.
    char* toPrint;
    toPrint = malloc(sizeof(char) * MAX_LEN * 2);
    memset(toPrint, '\0', MAX_LEN * 2);
    
    if(fputs("To,Location\n", outFile) < 0)
    	printf("Error in writing.\n");
    
    int i=0;
    
    // Repeats as long as the end of the input file is not reached.
    while(fgets(thisLine, MAX_LEN, inFile) != NULL)
    {
    	// Stores first line in "toPrint"
    	if(i==0)
	{
    		strncpy(toPrint, thisLine, strlen(thisLine) - 1);
    		i++;
    	}
    	
    	// Concatenates a comma, followed by the second line, to "toPrint".
    	// Prints "toPrint" to output file.
    	else if(i==1)
    	{
    		strncat(toPrint, ",", 2);
    		strncat(toPrint, thisLine, MAX_LEN);
    		
    		if(fputs(toPrint, outFile) < 0)
    			printf("Error in writing.\n");
    			
    		memset(toPrint, '\0', MAX_LEN * 2);
    		i++;
    	}
    	
    	// Causes third line to be removed (i.e. skipped).
    	else if(i==2)
    		i++;
    	
    	// Causes fourth line to be removed (i.e. skipped).
    	else if(i==3)
    		i=0;
    	
    	memset(thisLine, '\0', MAX_LEN);
    }
    
    // Informs user that execution was successful.
    printf("Pin assignment \"%s\" was successfully generated.\n", outFileName);
    return 0;
}

