------------------------------------------------------------------------------
--File Name: PWM.vhd
--Author: Robert Hood
--Group: Group1
--Project: iOS Remote Control Car
--Course: CMPE 450
--School: University of Alberta - Faculty of Engineering
--Date: Feb. 27, 2011

--References: Multi_PWM from www.grigaitis.eu
------------------------------------------------------------------------------

library ieee;
use ieee.std_logic_1164.all;
use ieee.std_logic_arith.all;
use ieee.std_logic_unsigned.all;

entity pwm is

port(
     
     clk 			: in std_logic; --clk is standard for both PWM and Avalon memory slave
     
     clk_reset	 		: in std_logic; --clk reset
     
     avs_pwm_write_n 		: in std_logic; --write
     avs_pwm_chipselect		: in std_logic; -- chip select
     avs_pwm_address 		: in std_logic; --address
     avs_pwm_readdata 		: out std_logic_vector(7 downto 0); --Needed for the Avalon interface
     avs_pwm_writedata 		: in std_logic_vector(7 downto 0); -- Data to be input represents the duty cycle

     pwm_output 		: out std_logic	 -- Ouput either 1 (high) or 0 (low)	
		
);

end entity;

architecture pwm_control of pwm is

signal pwm_signal,counter : std_logic_vector(7 downto 0);

begin
clk_proc : process (clk, clk_reset, avs_pwm_chipselect)
begin

--If reset is enabled, reset counter and pwm_signal values to zero
if clk_reset='1' then
counter<=(others=>'0'); 
pwm_signal<=(others=>'0'); 

--If not reset, proceed with PWM
elsif clk'event and clk='1' then 

--If the correct address, write low and chipselect are enabled, set "pwm_signal" equal to the value given set by user
if(avs_pwm_address = '0' and avs_pwm_write_n = '0' and avs_pwm_chipselect='0') 
then
	pwm_signal<=avs_pwm_writedata(7 downto 0);

end if;

--Increment the counter
counter <= counter +1;
if(counter = "11111111") then
counter <= "00000000";
end if;

--For as long as the "pwm_signal" value is greater than 0, and greater than the "counter" value, set the "pwm_output" to 1(high)
--Else set "pwm_output" it to 0(low)
if ((pwm_signal<counter)and (pwm_signal>0)) 
then
			   
	pwm_output<='1';
			  
else pwm_output<='0'; 
end if;

end if;

end process;
end pwm_control;

------------------------------------------------------------------------------
--File Name: PWM.vhd
--Author: Robert Hood
--Group: Group1
--Project: iOS Remote Control Car
--Course: CMPE 450
--School: University of Alberta - Faculty of Engineering
--Date: Feb. 27, 2011

--References: Multi_PWM from www.grigaitis.eu
------------------------------------------------------------------------------
