function nHopCDFmain
% ================================================================================
% date      : 2008-07-10
% note      : invokes 'nHopCDF' to compute CDF
% ================================================================================

y = logspace(-1,6,10);
n = 6;
sigma = [6,8,10,12]*0.1*log(10);
ps = {'r-','g-','b-','k-'}; % plot styles

% analytical curve
lg = {};
for k=1:length(sigma)
    display(sprintf('computing for sigma = %g',sigma(k)));
    cdf = nHopCDF(y,n,sigma(k),25);
    PlotCurve(y,cdf,ps{k}); hold on;
    lg = [lg, sprintf('\\sigma = %g dB',10*sigma(k)/log(10))];
end
FinishFigure(lg);

% ================================================================================
% plot each curve (with log-normal scaling)
% ================================================================================
function PlotCurve(x,y,ps)
    temp = sqrt(2)*erfinv(2*y-1);
    plot(10*log10(x),temp,ps,'LineWidth',2); 
    
% ================================================================================
% perform the finishing of the figure
% - legend entries are passed in
% ================================================================================
function FinishFigure(lg)

    % labels
    xlabel('y (dB)'); ylabel('CDF(y)');
    legend(lg);

    % grid
    grid on;
    
    % range of vertical axis to display
    sp = [1e-6,1e-5,1e-4,.001,.01,.1,.2,.3,.4,.5,.6,.7,.8,.9,.99,.999,1-1e-4,1-1e-5,1-1e-6,1-1e-7,1-1e-8,1-1e-9,1-1e-10,1-1e-11,1-1e-12];%,1-1e-13,1-1e-14,1-1e-15]; 
    ticks = sqrt(2)*erfinv(2*sp-1);
    
    % corresponding tick labels
    tl = {'1e-6','1e-5','1e-4','0.001','0.01','0.1','0.2','0.3','0.4','0.5','0.6','0.7','0.8','0.9','0.99','0.999','1-(1e-4)','1-(1e-5)','1-(1e-6)','1-(1e-7)','1-(1e-8)','1-(1e-9)','1-(1e-10)','1-(1e-11)','1-(1e-12)','1-(1e-13)','1-(1e-14)','1-(1e-15)'};
    set(gca,'YTick',ticks);
    set(gca,'YTickLabel',tl);

    % axis
    v = axis;
    v(3) = sqrt(2)*erfinv(2*min(sp)-1); % crop below
    v(4) = sqrt(2)*erfinv(2*max(sp)-1); % crop above
    axis(v);